 #include <sys/types.h>
 #include <sys/stat.h>
 #include <fcntl.h>
 #include <termios.h>
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <unistd.h>

 #define BAUDRATE B4800
 #define MODEMDEVICE "/dev/ttyUSB0"
 #define _POSIX_SOURCE 1 /* POSIX compliant source */
// #define FALSE 0
// #define TRUE 1
   
 //volatile int STOP=FALSE; 
 
int result(int HH,int LL){
  int xtemp;
  xtemp=256* HH+LL;
  if ( xtemp > 0x4000)
    return -(int)((0x4000 - (xtemp / 4)) * 0.03125) ;
  return (int)((xtemp / 4.0) * 0.03125);
}


 
int  main()
{
   int fd,j;
   struct termios oldtio,newtio;
//   char buf[255];
   unsigned char  startcmd01[6]={0x24,0x10,0x05,0x01,0x01,0x00};
   unsigned char  startcmd02[3]={0x32,0x01,0x55};
   unsigned char  stopcmd01[4]={0x24,0x11,0x01,0x00};
   unsigned char  stopcmd02[1]={0x55};
   unsigned char  readbuf[48];
   
   fd = open(MODEMDEVICE, O_RDWR | O_NOCTTY ); 
   if (fd <0) {perror(MODEMDEVICE); exit(-1); }
   
   tcgetattr(fd,&oldtio); /* save current port settings */
   
   bzero(&newtio, sizeof(newtio));
   newtio.c_cflag = BAUDRATE | CRTSCTS | CS8 | CLOCAL | CREAD;
   newtio.c_iflag = IGNPAR;
   newtio.c_oflag = 0;
   
   /* set input mode (non-canonical, no echo,...) */
   newtio.c_lflag = 0;
    
   newtio.c_cc[VTIME]    = 0;   /* inter-character timer unused */
//   newtio.c_cc[VMIN]     = 5;   /* blocking read until 5 chars received */
   newtio.c_cc[VMIN]     = 48;   /* blocking read until 5 chars received */
   
   tcflush(fd, TCIFLUSH);
   tcsetattr(fd,TCSANOW,&newtio);
   write(fd,startcmd01,6);
   write(fd,startcmd02,3);
   
   read(fd,readbuf,48);
   for(j=0;j<48;j++){
/*
     printf("%x,%x,%x,%x,%x,%x\n",readbuf[j+0],readbuf[j+1],
                                  readbuf[j+2],readbuf[j+3],
                                  readbuf[j+4],readbuf[j+5]);
*/
     if (readbuf[j+0]==0x24 && readbuf[j+1]==0xfe &&
         readbuf[j+2]==0x02 && readbuf[j+5]==0x55 )
     { 
        printf("Temperature is %d\n",result(readbuf[j+3],readbuf[j+4]));
        tcsetattr(fd,TCSANOW,&oldtio);
        write(fd,stopcmd01,4);
        write(fd,stopcmd02,1);
	exit(0);
     }
   }
   tcsetattr(fd,TCSANOW,&oldtio);
   printf("failed\n");
   write(fd,stopcmd01,4);
   write(fd,stopcmd02,1);
   close(fd);
   exit(0);
 }

